using System.Collections.Generic;
using System.Linq;
using HIPS.Client.Proxy;
using HIPS.PcehrDataStore.Schemas;
using HIPS.Web.Components.ServiceModel;
using HIPS.Web.ModelInterface.Common;

namespace HIPS.Web.Data.Hips.Reference
{
    public class HospitalRepository : IHospitalRepository
    {
        private ReferenceProxy proxy = new ReferenceProxy("HipsReferenceEndPoint");

        public List<Hospital> GetHospitals(string hospitalCodeSystem)
        {
            return proxy.ListHospitals()
                .Where(h => h.GetCodes(hospitalCodeSystem).Any())
                .OrderBy(h => h.Name)
                .ToList();
        }

        /// <summary>
        /// Performs application-defined tasks associated with freeing, releasing, or resetting unmanaged resources.
        /// </summary>
        public void Dispose()
        {
            if (proxy != null)
            {
                proxy.DisposeSafely();
                proxy = null;
            }
        }
    }
}
